<?php

class ReviewSiteMetaBox extends ReviewSiteApp
{

	/* Adds a custom section to the "advanced" Post and Page edit screens */
	function createBox()
	{
		if( function_exists( 'add_meta_box' )) :
    		add_meta_box( 1, __( 'Post Info' , 'reviewsite_box' )	,array("ReviewSiteMetaBox",'moreInfoBox'), 'post', 'advanced' );
			add_meta_box( 2, __( 'Rating Box', 'reviewsite_box' )	,array("ReviewSiteMetaBox",'ratingBox'), 'post', 'advanced' );
		endif;
	}
	
	/* color meta box */
	function moreInfoBox()
	{		
		global $post;
		
		$rating	= 5;
		
		function checkValue($value)
		{
			$check	= (sizeof($value) > 0) ? end($value) : NULL;
			return $check;
		}
		
		$visit_link	 	= checkValue(get_post_custom_values("reviewsite_visit_link"		,$post->ID));
		$post_rating 	= checkValue(get_post_custom_values("reviewsite_post_rating"	,$post->ID));
		
		// Use nonce for verification
		echo '<input type="hidden" name="reviewsite_box_noncename" id="reviewsite_box_noncename" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
		// The actual fields for data entry
		?>
        <div class="reviewSite-metabox">
        
        <!-- input 2 -->
        <label for="reviewsite_profile_photo">Visit Link</label>
        <input type="hidden" name="data[0][name]" value="reviewsite_visit_link" />
        <input type="text" name="data[0][value]" value="<?php echo $visit_link; ?>" size="70" />
        <br /><br />
        
        <!-- input 2 -->
        <label for="reviewsite_profile_photo">Post Rating</label>
        <input type="hidden" name="data[1][name]" value="reviewsite_post_rating" />
        <select name="data[1][value]">
        	<?php for($i = $rating;$i >= 1;$i--): ?>
            <option value="<?php echo $i; ?>" <?php if($i == $post_rating) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
            <?php endfor; ?>
        </select>
        <br /><br />
        
        </div>
        <?php	
	}
	
	function ratingBox()
	{
		global $reviewsite_rating,$post;
		
		$reviewsite_rating->getAll($post->ID);
		$reviewsite_rating->table();
		$reviewsite_rating->form();
	}

	/* When the post is saved, saves our custom data */
	function savePostdata( $post_id ) 
	{

  		// verify this came from the our screen and with proper authorization,
  		// because save_post can be triggered at other times

  		if ( !wp_verify_nonce( $_POST['reviewsite_box_noncename'], plugin_basename(__FILE__) )) 
		{	return $post_id;	}

  		// verify if this is an auto save routine. If it is our form has not been submitted, so we dont want
  		// to do anything
  		if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
    	return $post_id;
		
		for($i = 0;$i <= count($_POST['data'])-1;$i++) :
			
			$custom_name	= $_POST['data'][$i]['name'];
				
			if(isset($_POST['data'][$i]['delete']) && $_POST['data'][$i]['delete'] == "yes") :
				delete_post_meta($post_id,$custom_name);
			else :
				update_post_meta($post_id,$custom_name,$_POST['data'][$i]['value']);
			endif;
			
		endfor;
		
		// for saving data from rating
		if( 'post' == $_POST['post_type']) :
			global $reviewsite_rating;
			$reviewsite_rating->post($post_id);
		endif;

   		return $post_id;
	}
	
	function isAllowedExtension($fileName)
	{
		$allowedExtensions = array("png", "gif", "jpg", 'jpeg');
		return in_array(end(explode(".", $fileName)), $allowedExtensions);
	}
	
	function metaBoxScripts()
	{
		wp_enqueue_script('media-upload');
		wp_enqueue_script('thickbox');
		wp_register_script('my-upload', get_bloginfo('template_url').'/admin/js/script.js', array('jquery','media-upload','thickbox'));
		wp_enqueue_script('my-upload');
	}
	
	function metaBoxStyles()
	{
		wp_enqueue_style('thickbox');
	}
	
}

/* Use the admin_menu action to define the custom boxes */

$className	= "ReviewSiteMetaBox";

add_action('admin_menu'			, array($className,"createBox"));
add_action('save_post'			, array($className,'savePostdata'));
add_action('admin_print_scripts', array($className,'metaBoxScripts'));
add_action('admin_print_styles'	, array($className,'metaBoxStyles'));

?>